/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.viewer;

import filenet.sim.apps.viewer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWSIMAnimatorSetPlaybackRateDialog
extends VWModalDialog
implements ActionListener {
    private boolean m_bCanceled = false;
    private JTextArea m_prompt = null;
    private JTextArea m_infoTextArea = null;
    private VWNumericTextField m_playbackTextField = null;
    private static int s_minPlaybackRate = 1;
    private static int s_maxPlaybackRate = 9999;
    private JButton m_okButton = new JButton(VWSIMResource.s_ok);
    private JButton m_cancelButton = new JButton(VWSIMResource.s_cancel);
    private JButton m_helpButton = new JButton(VWSIMResource.s_help);
    private int m_playbackRate = 100;

    public VWSIMAnimatorSetPlaybackRateDialog(Frame parent, int playbackRate) {
        super(parent);
        this.m_playbackRate = playbackRate;
        this.setupLayout();
    }

    public VWSIMAnimatorSetPlaybackRateDialog(Dialog parent, int playbackRate) {
        super(parent);
        this.m_playbackRate = playbackRate;
        this.setupLayout();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("440,200");
        if (dim == null) {
            dim = new Dimension(400, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWSIMResource.s_setPlaybackRate);
        this.m_prompt = new JTextArea(VWSIMResource.s_setPlaybackRatePrompt.toString(Integer.toString(s_minPlaybackRate), Integer.toString(s_maxPlaybackRate)));
        this.m_prompt.setLineWrap(true);
        this.m_prompt.setWrapStyleWord(true);
        this.m_prompt.setOpaque(false);
        this.m_prompt.setEditable(false);
        int maxDigits = Integer.toString(s_maxPlaybackRate).length();
        this.m_playbackTextField = new VWNumericTextField(maxDigits, 0, false);
        this.m_playbackTextField.setText(Integer.toString(this.m_playbackRate));
        this.m_infoTextArea = new JTextArea(VWSIMResource.s_playbackRateExtraInfo);
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        JPanel playbackRatepanel = new JPanel();
        playbackRatepanel.setLayout(new FlowLayout(3));
        playbackRatepanel.add(new JLabel(VWSIMResource.s_label.toString(VWSIMResource.s_preferredPlaybackRate)));
        playbackRatepanel.add(this.m_playbackTextField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(this.m_prompt);
        mainPanel.add(playbackRatepanel);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(this.m_infoTextArea);
        mainPanel.add(buttonPanel);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_okButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_okButton.setSelected(true);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_prompt.setFont(boldFont);
        }
        this.m_playbackTextField.requestFocus();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public int getPlaybackRate() {
        return this.m_playbackRate;
    }

    private boolean parsePlaybackRate() {
        String timeString = this.m_playbackTextField.getText();
        int playbackRate = -1;
        try {
            playbackRate = Integer.parseInt(timeString);
        }
        catch (NumberFormatException ex) {
            playbackRate = -1;
        }
        if (playbackRate == -1 || playbackRate < s_minPlaybackRate || playbackRate > s_maxPlaybackRate) {
            JOptionPane.showMessageDialog(this, VWSIMResource.s_invalidValue, this.getTitle(), 0);
            return false;
        }
        this.m_playbackRate = playbackRate;
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_okButton) {
            this.m_bCanceled = false;
            if (this.parsePlaybackRate()) {
                this.setVisible(false);
            }
        } else if (source == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (source == this.m_helpButton) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Animator + "vwsimanimatorsetplaybackdialog.htm");
        } else if (source == this.m_playbackTextField) {
            JButton defButton = this.getRootPane().getDefaultButton();
            if (defButton != null) {
                defButton.doClick();
            } else if (this.m_okButton != null) {
                this.m_okButton.doClick();
            }
        }
    }

    void releaseResources() {
        this.setTitle(null);
        this.m_okButton.removeActionListener(this);
        this.m_cancelButton.removeActionListener(this);
        this.m_infoTextArea = null;
        this.m_playbackTextField = null;
        this.m_okButton = null;
        this.m_cancelButton = null;
        super.removeReferences();
        this.removeAll();
    }
}

